//=============================================================================
// 7.8fcCannister.
//=============================================================================
class GhostShell extends OrangePhotonBlast;

var ParticleGenerator smokeGen;
var name damageType;			// type of damage that this projectile does
var float	mpBlastRadius;
var() bool           bDamaged;         // was this blown up via damage?

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ExplosionLight light;
	local int i;
	local Rotator rot;
	local OFCEffect sphere;
   local ExplosionSmall expeffect;

	// draw a pretty explosion
	light = Spawn(None,,, HitLocation);
	if (light != None)
	{
      if (!bDamaged)
         light.RemoteRole = ROLE_None;
		light.size = 8;
		light.LightHue = 128;
		light.LightSaturation = 96;
		light.LightEffect = LE_Shell;
	}

	expeffect = Spawn(None,,, HitLocation);
   if ((expeffect != None) && (!bDamaged))
      expeffect.RemoteRole = ROLE_None;

	// draw a cool light sphere
	sphere = Spawn(class'Markistan.OFCEffect',,, HitLocation);
	if (sphere != None)
   {
      if (!bDamaged)
         sphere.RemoteRole = ROLE_None;
		sphere.size = blastRadius / 32.0;
   }
}

function PostBeginPlay()
{
	Super.PostBeginPlay();

   if (Level.NetMode == NM_DedicatedServer)
      return;
   
   SpawnSmokeEffects();
}

simulated function PostNetBeginPlay()
{
   Super.PostNetBeginPlay();
   
   if (Role != ROLE_Authority)
      SpawnSmokeEffects();
}

simulated function SpawnSmokeEffects()
{
	smokeGen = Spawn(class'ParticleGenerator', Self);
	if (smokeGen != None)
	{
		smokeGen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
		smokeGen.particleDrawScale = 0.3;
		smokeGen.checkTime = 0.02;
		smokeGen.riseRate = 8.0;
		smokeGen.ejectSpeed = 0.0;
		smokeGen.particleLifeSpan = 2.0;
		smokeGen.bRandomEject = True;
		smokeGen.SetBase(Self);
      smokeGen.RemoteRole = ROLE_None;
	}
}

simulated function Destroyed()
{
	if (smokeGen != None)
		smokeGen.DelayedDestroy();

	Super.Destroyed();
}

defaultproperties
{
     DamageType=Disintegrated
     bExplodes=True
     bBlood=True
     bDebris=True
     blastRadius=256.000000
     AccurateRange=400
     maxRange=800
     ItemName="7.8fc Ghost Shell"
     ItemArticle="a"
     speed=1000.000000
     MaxSpeed=1000.000000
     Damage=78.000000
     MomentumTransfer=200000
     ImpactSound=Sound'DeusExSounds.Generic.MediumExplosion2'
     Skin=Texture'Markistan.Effects.SpeckedOrangePhoton'
     Mesh=LodMesh'DeusExItems.HECannister20mm'
     DrawScale=1.000000
     bCollideWorld=False
}
